<?php /*
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Admin') ?></title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .sidebar { width: 260px; min-height: 100vh; }
    .sidebar a { text-decoration: none; }
    .sidebar .active { background: rgba(13,110,253,.12); border-radius: .5rem; }
  </style>
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Admin SMAS</a>
    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<div class="d-flex">
  <aside class="sidebar bg-white border-end p-3">
    <div class="fw-bold mb-2">Menu</div>

    <?php $uri = service('uri')->getPath(); ?>

    <div class="list-group list-group-flush">
      <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         href="<?= site_url('admin') ?>">Dashboard</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/berita') ? 'active' : '' ?>"
         href="<?= site_url('admin/berita') ?>">Berita</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/galeri') ? 'active' : '' ?>"
         href="<?= site_url('admin/galeri') ?>">Galeri</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/halaman') ? 'active' : '' ?>"
         href="<?= site_url('admin/halaman') ?>">Halaman (Tentang/Sejarah)</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/akun') ? 'active' : '' ?>"
         href="<?= site_url('admin/akun') ?>">Akun Admin</a>
    </div>
  </aside>

  <main class="flex-grow-1 p-4">
    <?= $this->renderSection('content') ?>
  </main>
</div>

</body>
</html>
   */ ?>